// SetAccountExtRefID.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "SetAccountExtRefID.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#if defined WPPCS
/////////////////////////////////////////////////////////////////////////////
// CSetAccountExtRefID dialog


CSetAccountExtRefID::CSetAccountExtRefID(CWnd* pParent /*=NULL*/)
	: CDialog(CSetAccountExtRefID::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSetAccountExtRefID)
	m_ExtRefID = _T("");
	//}}AFX_DATA_INIT
}

CSetAccountExtRefID ::CSetAccountExtRefID(IApplication *pApp):CDialog(CSetAccountExtRefID::IDD, NULL)
{
	pApplication = pApp;
	
}
void CSetAccountExtRefID::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetAccountExtRefID)
	DDX_Control(pDX, IDC_EXTREFID, m_CtlExtRefID);
	DDX_Control(pDX, IDC_ACCTLIST, m_AcctList);
	DDX_Text(pDX, IDC_EXTREFID, m_ExtRefID);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSetAccountExtRefID, CDialog)
	//{{AFX_MSG_MAP(CSetAccountExtRefID)
	ON_BN_CLICKED(IDSET, OnSet)
	ON_BN_CLICKED(IDCLEAR, OnClear)
	ON_CBN_SELCHANGE(IDC_ACCTLIST, OnSelchangeAcctlist)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSetAccountExtRefID message handlers
BOOL CSetAccountExtRefID::OnInitDialog() 
{
	CDialog::OnInitDialog();
	LoadAccounts();
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
void CSetAccountExtRefID :: LoadAccounts()
{
		_variant_t vAccounts;
		vAccounts.Clear();
		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				CString sAcctid;
				sAcctid.Format(L"%ld",pAccount->AccountID);
				m_AcctList.AddString(sAcctid);
				pAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
}
void CSetAccountExtRefID::OnSet() 
{
		BSTR bstrExtRefID =::SysAllocString(L"");
		UpdateData(TRUE);
		//select Account ID
		long lAcctID;
		int index_Acct = m_AcctList.GetCurSel();
		if (index_Acct < 0)
			lAcctID = 0;
		else
		{
			CString sAcctID;
			m_AcctList.GetLBText(index_Acct,sAcctID);
			lAcctID = _wtoi(sAcctID);
		}
		bstrExtRefID = m_ExtRefID.AllocSysString();
		// set the external reference ID to Account
		long lStatus;
		pApplication->SetExtRefIDByAcctID(lAcctID,bstrExtRefID,&lStatus);
		// get corresponding Status values
		if ( lStatus == 105)
		{
			AfxMessageBox(L"Invalid Account ID");
			return;
		}
		if (lStatus == 401)
		{
			AfxMessageBox(L"Invalid ExtRefID");
			return;
		}
		if(lStatus == 402)
		{
			AfxMessageBox(L"ExtRefID Already Exists");
			return;
		}
		if(lStatus == 404)
		{
			AfxMessageBox(L"Invalid ExtRefID Length");
			return;
		}
		if (lStatus == 1)
		{
			AfxMessageBox(L"Set ExtRefID Failed");
			return;
		}
		if ( lStatus == 0)
		{
			AfxMessageBox(L"Set ExtRefID Succeeded");
			m_CtlExtRefID.SetWindowText(L"");
			return;
			//CDialog::OnOK();
		}
	
	UpdateData(FALSE);
	
}

void CSetAccountExtRefID::OnClear() 
{
	//select Account ID
		m_CtlExtRefID.SetWindowText(L"");
		long lAcctID;
		int index_Acct = m_AcctList.GetCurSel();
		if (index_Acct < 0)
			lAcctID = 0;
		else
		{
			CString sAcctID;
			m_AcctList.GetLBText(index_Acct,sAcctID);
			lAcctID = _wtoi(sAcctID);
		}
		// clear the external reference ID to account
		long lStatus;
		pApplication->ClearExtRefIDByAcctID(lAcctID,&lStatus);
		// get corresponding Status values
		if ( lStatus == 105)
		{
			AfxMessageBox(L"Invalid Account ID");
			return;
		}
		if ( lStatus == 403)
		{
			AfxMessageBox(L"ExtRefID Not Exist");
			return;
		}	
		if (lStatus == 1)
		{
			AfxMessageBox(L"Clear ExtRefID Failed");
			return;
		}
		if ( lStatus == 0)
		{
			AfxMessageBox(L"Clear ExtRefID Succeeded");
			//m_CtlExtRefID.SetWindowText(L"");
			return;
			//CDialog::OnOK();
		}
	
}
void CSetAccountExtRefID::LoadAccountDetails()
{
	//select Account ID
		long lAcctID;
		int index_Acct = m_AcctList.GetCurSel();
		if (index_Acct < 0)
			lAcctID = 0;
		else
		{
			CString sAcctID;
			m_AcctList.GetLBText(index_Acct,sAcctID);
			lAcctID = _wtoi(sAcctID);
		}
		_variant_t vAccount;
		vAccount.Clear();
		pApplication->GetAccountByAcctID(lAcctID,&vAccount);
		
		if(vAccount.vt ==  VT_EMPTY)
		{
			return;
		}
		UpdateData(TRUE);
		if( vAccount.vt & VT_DISPATCH)
		{
			
			IAccountPtr pAcct(vAccount.pdispVal);
			m_ExtRefID =CString(((LPWSTR)pAcct->ExtRefID));
		}
		UpdateData(FALSE);

		if(NULL != vAccount.pdispVal)
		{
			vAccount.Clear();
		}	
}

void CSetAccountExtRefID::OnSelchangeAcctlist() 
{
	//m_CtlExtRefID.SetWindowText("");
	LoadAccountDetails();
	
}
#endif //WPPCS